# Динозавры
Динозавры — это древние величественные существа, которых можно разводить для получения древних костей.

К сожалению, динозавры давным-давно вымерли, поэтому нам остается только нарядиться одним из них.
Для этой цели ты получаешь новую шляпу динозавра.

Шляпу можно надеть с помощью
`change_hat(Hats.Dinosaur_Hat)`

К сожалению, она не совсем такая, как в рекламе...

Если надета шляпа динозавра и у тебя достаточно кактусов, [яблоко](objects/apple) будет автоматически куплено и размещено под дроном.
Когда дрон находится над яблоком и движется снова, он съедает яблоко, а его хвост удлиняется на один сегмент. Если ты можешь себе это позволить, новое яблоко будет куплено и размещено в случайном месте.
Яблоко не может появиться, если на его месте что-то посажено.

Хвост динозавра будет тащиться за дроном, заполняя предыдущие клетки, по которым двигался дрон. Если дрон попытается переместиться на хвост, `move()` не сработает и вернет `False`.
Последний сегмент хвоста уйдет с пути во время движения, и ты сможешь переместиться на его место. Однако, если змейка заполнит всю ферму, ты больше не сможешь двигаться. Так что можно узнать, выросла ли змейка полностью, по тому, осталась ли у дрона возможность двигаться.

Если применить `measure()` к яблоку, вернется позиция следующего яблока в виде кортежа.

`next_x, next_y = measure()`

Если ты снимешь эту шляпу, надев другую, то соберешь хвост.
При этом ты получишь кости в количестве, равном квадрату длины хвоста. Так, за хвост длиной `n` ты получишь `n**2` `Items.Bone`.
Например:
длина 1 => 1 кость
длина 2 => 4 кости
длина 3 => 9 костей
длина 4 => 16 костей
длина 16 => 256 костей
длина 100 => 10 000 костей

Шляпа динозавра очень тяжелая, так что в ней выполнение `move()` будет занимать 400 тиков вместо 200. Однако с каждым подобранным яблоком количество тиков, занимаемых `move()`, уменьшается на 3% (с округлением в меньшую сторону), потому что длинный хвост помогает двигаться быстрее.

Следующий цикл выводит количество тиков, занимаемых `move()` после любого количества яблок:

`ticks = 400
for i in range(100):
    print("тики после ", i, " яблок: ", ticks)
    ticks -= ticks * 0.03 // 1`

У тебя есть только одна шляпа динозавра, поэтому носить ее может только один дрон.

<spoiler=показать подсказку 1>Если ты будешь двигаться по одному и тому же пути, который покрывает все поле, то легко сможешь каждый раз получать змейку, покрывающую все поле. Не самый эффективный способ, но помогает.
Полный облет фермы очень большого размера может занять много времени. К тому же тебе, возможно, нужно не так много костей. Смело используй `set_world_size()`, чтобы уменьшить ферму до более удобного размера.</spoiler>